#include <iostream>
#include "make.h"
#include "defs.h"
#include "attack.h"
#include "bits.h"

using namespace std;

bool makemove(cBoard &pboard, cMaterial &material, cHistory &his, uint &move)
{
    //cout<<" make ";
  //  pboard.printboard();
#ifdef DEEPDEBUG
  ASS(position_check(pboard,material));
#endif
  sRecord *hist = his.p2history();
  uint gamemoves = his.getmoves();
  uint *board = pboard.p2board();
  uint side = pboard.getside();
  uint from = FROM(move);
  uint to = TO(move);
  uint captured = board[to];
  uint piece = board[from];

//  cout<<printsquare(from)<<printsquare(to);

  ASS(onbrd(from));
  ASS(onbrd(to));
  ASS(gamemoves<maxgamelength);
  ASS(side==cW||side==cB);
  ASS(piecegood(captured));
  ASS(piecegood(piece));
  ASS(captured!=pwK&&captured!=pbK);
#ifdef DEBUG
  if(captured!=pE)
  ASS(pcecolour(captured)!=side);
#endif

  //put current info into the history...
  hist[gamemoves].move = move;
  hist[gamemoves].enpas = pboard.getenpas();
  hist[gamemoves].castle = pboard.getcastle();
  hist[gamemoves].fifty = pboard.getfifty();
  hist[gamemoves].captured = captured;
  hist[gamemoves].key = pboard.getkey();
  hist[gamemoves].pawnkey = pboard.getpawnkey();

  pboard.hashcastle();
  pboard.hashside();
  pboard.hashenpas();

  //castle permissons and enpassant reset
  pboard.setenpas(NOSQ);
  pboard.updatecastle(castlebits[from]);
  pboard.updatecastle(castlebits[to]);


  //move the piece being moved
  board[to] = board[from];
  board[from] = pE;

  material.movepiece(piece, from, to);
  material.movepsqt(piece, from, to);

  pboard.hashpiece(piece,from);
  pboard.hashpiece(piece,to);

  if(captured>pE)
  {
   pboard.resetfifty();
   material.removepiece(captured, to);
   material.removepsqt(captured, to);
   pboard.hashpiece(captured,to);
   if(captured<=pbP)
   {
    clearbit(to,material.getboard(captured));
    pboard.hashpawn(captured,to);
   }
  }

  switch (piece)
  {
         case pwP:
              pboard.resetfifty();
              pboard.hashpawn(pwP,from);
              pboard.hashpawn(pwP,to);
              movebit(from,to,material.getboard(pwP));
              if(FLAG(move)==FlagEP)
              {
                board[to+S] = pE;
                material.removepiece(pbP,(to+S));
                material.removepsqt(pbP, to+S);
                pboard.hashpiece(pbP,(to+S));
                pboard.hashpawn(pbP,(to+S));
                clearbit(to+S,material.getboard(pbP));
              }
              else if(PROM(move))
              {
                   ASS(ranks[to]==RANK8);
                   material.removepiece(pwP,to);
                   material.removepsqt(pwP, to);
                   pboard.hashpiece(pwP,to);
                   pboard.hashpawn(pwP,to);
                   clearbit(to,material.getboard(pwP));
                   switch (PROM(move))
                   {
                      case pwQ :
                           board[to] = pwQ;
                           material.addpiece(pwQ,to);
                           material.addpsqt(pwQ, to);
                           pboard.hashpiece(pwQ,to);
                           break;
                      case pwR :
                           board[to] = pwR;
                           material.addpiece(pwR,to);
                           material.addpsqt(pwR, to);
                           pboard.hashpiece(pwR,to);
                           break;
                      case pwB :
                           board[to] = pwB;
                           material.addpiece(pwB,to);
                           material.addpsqt(pwB, to);
                           pboard.hashpiece(pwB,to);
                           break;
                      case pwN :
                           board[to] = pwN;
                           material.addpiece(pwN,to);
                           material.addpsqt(pwN, to);
                           pboard.hashpiece(pwN,to);
                           break;
                      default: cout<<"\n prom piece error"; exit(1);
                      break;

                   };
              }
              else if(ranks[from]==RANK2 && ranks[to]==RANK4)
              {
                   pboard.setenpas((to+S));
                   ASS(ranks[pboard.getenpas()]==RANK3);
              }
              break;
         case pbP:
              pboard.resetfifty();
              pboard.hashpawn(pbP,from);
              pboard.hashpawn(pbP,to);
              movebit(from,to,material.getboard(pbP));
              if(FLAG(move)==FlagEP)
              {
                board[to+N] = pE;
                material.removepiece(pwP,(to+N));
                material.removepsqt(pwP, to+N);
                pboard.hashpiece(pwP,(to+N));
                pboard.hashpawn(pwP,(to+N));
                clearbit(to+N,material.getboard(pwP));
              }
              else if(PROM(move))
              {
                   ASS(ranks[to]==RANK1);
                   material.removepiece(pbP,to);
                   material.removepsqt(pbP, to);
                   pboard.hashpiece(pbP,to);
                   pboard.hashpawn(pbP,to);
                   clearbit(to,material.getboard(pbP));
                   switch (PROM(move))
                   {
                      case pbQ :
                           board[to] = pbQ;
                           material.addpiece(pbQ,to);
                           material.addpsqt(pbQ, to);
                           pboard.hashpiece(pbQ,to);
                           break;
                      case pbR :
                           board[to] = pbR;
                           material.addpiece(pbR,to);
                           material.addpsqt(pbR, to);
                           pboard.hashpiece(pbR,to);
                           break;
                      case pbB :
                           board[to] = pbB;
                           material.addpiece(pbB,to);
                           material.addpsqt(pbB, to);
                           pboard.hashpiece(pbB,to);
                           break;
                      case pbN :
                           board[to] = pbN;
                           material.addpiece(pbN,to);
                           material.addpsqt(pbN, to);
                           pboard.hashpiece(pbN,to);
                           break;

                      default: cout<<"\n prom piece error"; exit(1);
                      break;
                   };
              }
              else if(ranks[from]==RANK7 && ranks[to]==RANK5)
              {
                   pboard.setenpas((to+N));
                   ASS(ranks[pboard.getenpas()]==RANK6);
              }
              break;
         default: break;
  };

  //castling
  if(FLAG(move)==FlagCA)
  {
     ASS(piece==pwK || piece==pbK);
     if(side==cW)
     {
       if(to==G1)
       {
         board[H1]=pE; board[F1]=pwR;
         material.movepiece(pwR, H1, F1);
         material.movepsqt(pwR, H1, F1);
         pboard.hashpiece(pwR,H1);
         pboard.hashpiece(pwR,F1);
       }
       else
       {
         ASS(to==C1);
         board[A1]=pE; board[D1]=pwR;
         material.movepiece(pwR, A1, D1);
         material.movepsqt(pwR, A1, D1);
         pboard.hashpiece(pwR,A1);
         pboard.hashpiece(pwR,D1);
       }
     }
     else
     {
       ASS(side==cB);
       if(to==G8)
       {
         board[H8]=pE; board[F8]=pbR;
         material.movepiece(pbR, H8, F8);
         material.movepsqt(pbR, H8, F8);
         pboard.hashpiece(pbR,H8);
         pboard.hashpiece(pbR,F8);
       }
       else
       {
         ASS(to==C8);
         board[A8]=pE; board[D8]=pbR;
         material.movepiece(pbR, A8, D8);
         material.movepsqt(pbR, A8, D8);
         pboard.hashpiece(pbR,A8);
         pboard.hashpiece(pbR,D8);
       }
     }
  }



#ifdef DEBUG
uint kingsq = material.getkingsq(side);
  if(side==cW)
  ASS(board[kingsq]==pwK);
  else
  ASS(board[kingsq]==pbK);
#endif


  pboard.setside((side^1));
  pboard.incrply();
  his.incrgamemoves();

  pboard.hashcastle();
  pboard.hashside();
  pboard.hashenpas();

  return incheck(pboard, material, side);

}

void takemove(cBoard &pboard, cMaterial &material, cHistory &his)
{

  //cout<<" take ";
  his.decrgamemoves();
  pboard.decrply();

  sRecord *hist = his.p2history();
  uint gamemoves = his.getmoves();
  uint *board = pboard.p2board();
  uint side = pboard.getside();

  uint move = hist[gamemoves].move;
  uint from = FROM(move);
  uint to = TO(move);
  uint piece = board[to];
  uint captured = hist[gamemoves].captured;

  pboard.setkey(hist[gamemoves].key);
  pboard.setpawnkey(hist[gamemoves].pawnkey);
  pboard.setfifty(hist[gamemoves].fifty);
  pboard.setenpas(hist[gamemoves].enpas);
  pboard.setcastle(hist[gamemoves].castle);

  ASS(onbrd(from));
  ASS(onbrd(to));
  ASS(gamemoves<maxgamelength);
  ASS(side==cW||side==cB);
  ASS(piecegood(captured));
  ASS(piecegood(piece));
  ASS(captured!=pwK&&captured!=pbK);
#ifdef DEBUG
  if(captured!=pE)
  ASS(pcecolour(captured)==side);//not changed the side yet, so captureds has the same colour
#endif

  //move piece on board back
  board[from] = board[to];
  board[to] = captured;

  material.movepiece(piece, to, from);
  material.movepsqt(piece, to, from);
  if(piece<=pbP)
  movebit(to, from, material.getboard(piece));
  if(captured>pE)
  {
    material.addpiece(captured, to);
    material.addpsqt(captured, to);
    if(captured<=pbP)
    setbit(to,material.getboard(captured));
  }


  side^=1;

    //special pawn moves
   if(FLAG(move)==FlagEP)
   {
      if(side==cW)
      {
          board[to+S] = pbP;
          material.addpiece(pbP,(to+S));
          material.addpsqt(pbP, to+S);
          setbit(to+S, material.getboard(pbP));
      }
      else
      {
          board[to+N] = pwP;
          material.addpiece(pwP,(to+N));
          material.addpsqt(pwP, to+N);
          setbit(to+N, material.getboard(pwP));
      }
   }
   else if(PROM(move))
   {
      if(side==cW)
      {
        material.addpiece(pwP,from);
        material.addpsqt(pwP, from);
        board[from]=pwP;
        setbit(from, material.getboard(pwP));
      }
      else
      {
        material.addpiece(pbP,from);
        material.addpsqt(pbP, from);
        board[from]=pbP;
        setbit(from, material.getboard(pbP));
      }
      material.removepiece(PROM(move),from);
      material.removepsqt(PROM(move),from);
   }
    //castling
   else if(FLAG(move)==FlagCA)
   {
     ASS(piece==pwK || piece==pbK);
     if(side==cW)
     {
       if(to==G1)
       {
         board[H1]=pwR; board[F1]=pE;
         material.movepiece(pwR, F1, H1);
         material.movepsqt(pwR, F1, H1);
       }
       else
       {
         ASS(to==C1);
         board[A1]=pwR; board[D1]=pE;
         material.movepiece(pwR, D1, A1);
         material.movepsqt(pwR, D1, A1);
       }
     }
     else
     {
       ASS(side==cB);
       if(to==G8)
       {
         board[H8]=pbR; board[F8]=pE;
         material.movepiece(pbR, F8, H8);
         material.movepsqt(pbR, F8, H8);
       }
       else
       {
         ASS(to==C8);
         board[A8]=pbR; board[D8]=pE;
         material.movepiece(pbR, D8, A8);
         material.movepsqt(pbR, D8, A8);
       }
     }
   }

   pboard.changeside();
   #ifdef DEEPDEBUG
   ASS(position_check(pboard,material));
   #endif
}


void makenullmove(cBoard &pboard, cMaterial &material, cHistory &his)
{

#ifdef DEEPDEBUG
  ASS(position_check(pboard,material));
#endif
  sRecord *hist = his.p2history();
  uint gamemoves = his.getmoves();
  uint side = pboard.getside();

  ASS(gamemoves<maxgamelength);
  ASS(side==cW||side==cB);

  //put current info into the history...
  hist[gamemoves].move = NULLMOVE;
  hist[gamemoves].enpas = pboard.getenpas();
  hist[gamemoves].castle = pboard.getcastle();
  hist[gamemoves].fifty = pboard.getfifty();
  hist[gamemoves].captured = pE;
  hist[gamemoves].key = pboard.getkey();
  hist[gamemoves].pawnkey = pboard.getpawnkey();

  pboard.hashside();
  pboard.hashenpas();

  pboard.setenpas(NOSQ);

  pboard.setside((side^1));
  pboard.incrply();
  his.incrgamemoves();

  pboard.hashside();
  pboard.hashenpas();

#ifdef DEBUG
   ASS(!incheck(pboard, material, side));
#endif

}

void takenullmove(cBoard &pboard, cHistory &his)
{

  his.decrgamemoves();
  pboard.decrply();

  sRecord *hist = his.p2history();
  uint gamemoves = his.getmoves();

  uint move = hist[gamemoves].move;

  ASS(move==NULLMOVE);
  ASS(gamemoves<maxgamelength);

  pboard.setkey(hist[gamemoves].key);
  pboard.setpawnkey(hist[gamemoves].pawnkey);
  pboard.setfifty(hist[gamemoves].fifty);
  pboard.setenpas(hist[gamemoves].enpas);
  pboard.setcastle(hist[gamemoves].castle);

  pboard.changeside();
  #ifdef DEEPDEBUG
  ASS(position_check(pboard,material));
  #endif
}
